<?php namespace App\Controllers\Api\Customer\Profile\Subscribe;

use App\Controllers\PrivateController;
use App\Libraries\Common;
use App\Models\AppsModel;
use App\Models\SubscribesModel;
use App\Models\PlansModel; // Thêm model PlansModel
use CodeIgniter\HTTP\ResponseInterface;

define("LIMIT", 20);

class Subscribes extends PrivateController
{
    /**************************************************************************************
     * PUBLIC FUNCTIONS
     **************************************************************************************/

    /**
     * Get user subscribes
     * @return ResponseInterface
     */
    public function index(): ResponseInterface
    {
        $offset = (int) $this->request->getGet("offset");

        $subscribes = new SubscribesModel();
      	$plans = new PlansModel(); // Khởi tạo PlansModel

        $list = $subscribes
            ->where("user_id", $this->userId)
            ->where("is_disable", 0)
            ->orderBy("id", "DESC")
            ->findAll(LIMIT, $offset);

        $items = [];

        $common = new Common();

        if ($list) {
            $app_ids = [];
          	$plan_ids = []; // Tạo mảng để lưu plan_id
            foreach ($list as $item) {
                $app_ids[] = $item["app_id"];
              	$plan_ids[] = $item["plan_id"]; // Thêm plan_id vào mảng
            }

            $projects = new AppsModel();

            $apps = $projects
                ->whereIn("id", $app_ids)
                ->select("uid,name,id")
                ->findAll();
          
          	// Lấy thông tin của các plan
            $plansData = $plans
                ->whereIn("id", $plan_ids)
                ->findAll();

            foreach ($list as $item) {
                $app = null;
                foreach ($apps as $app_item) {
                    if ($app_item["id"] == $item["app_id"]) {
                        $app = $app_item;
                        break;
                    }
                }
              	
              	// Tìm plan tương ứng
                $plan = null;
                foreach ($plansData as $plan_item) { // Sử dụng $plansData thay vì $plans
                    if ($plan_item["id"] == $item["plan_id"]) {
                        $plan = $plan_item;
                        break;
                    }
                }
              	
                if ($app && $plan) {
                    $items[] = [
                        "uid"        => $item["uid"],
                        "created_at" => date('d-m-Y H:i', $item['created_at']),
                        "expires_at" => date('d-m-Y H:i', $item['expires_at']),
                        "price"      => $item["price"],
                        "app"        => [
                            "name" => $app["name"],
                            "uid"  => $app["uid"],
                            "icon" => $common->get_icon($app["uid"])
                        ],
                        "is_active"  => (bool) $item["is_active"],
                        "remaining_count" => $item["remaining_count"] ?? 0,
                        "build_count" => $plan["build_count"] ?? 0 // Lấy build_count từ plan
                    ];
                }
            }
        }

        $total = $subscribes
            ->where("user_id", $this->userId)
            ->countAllResults();

        return $this->respond(["list" => $items, "total" => $total], 200);
    }

    /**************************************************************************************
     * PRIVATE FUNCTIONS
     **************************************************************************************/


}